/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.CEADescriptor;

public abstract class DataBlock {
    protected int iDataBlockTagCode;
    protected static final int iMaxDataBlockLength = 32;
    protected int iMaxNumberDescriptors;
    private int iCurrentNumberDescriptors;
    private int iIndividualDescriptorLength;
    private int iCurrentTotalDescriptorLength;

    public DataBlock(int n) {
        this.iMaxNumberDescriptors = 31 / n;
        this.iCurrentNumberDescriptors = 0;
        this.iIndividualDescriptorLength = n;
        this.iCurrentTotalDescriptorLength = 0;
    }

    public void setHeader(String string) {
        this.iDataBlockTagCode = Integer.parseInt(string.substring(0, 2), 16) >> 5;
        this.iCurrentTotalDescriptorLength = Integer.parseInt(string.substring(0, 2), 16) & 0x1F;
        this.iCurrentNumberDescriptors = this.iCurrentTotalDescriptorLength / this.iIndividualDescriptorLength;
    }

    public String getHeader() {
        int n = (this.iDataBlockTagCode << 5) + this.getTotalDescriptorLength();
        return String.format("%02X", n);
    }

    public int getTotalDescriptorLength() {
        return this.iCurrentTotalDescriptorLength;
    }

    public int getDataBlockLength() {
        return 1 + this.iCurrentTotalDescriptorLength;
    }

    public int getCurrentNumDescriptors() {
        return this.iCurrentNumberDescriptors;
    }

    public void adjustNumDescriptors(int n) {
        if (n == 0) {
            this.iCurrentNumberDescriptors = 0;
            this.iCurrentTotalDescriptorLength = 0;
        } else {
            this.iCurrentNumberDescriptors += n;
            this.iCurrentTotalDescriptorLength += this.iIndividualDescriptorLength * n;
        }
    }

    public void adjustDescriptorLength_VendorSpecific(int n, int n2) {
        this.iCurrentTotalDescriptorLength = n2 * n;
        this.iCurrentNumberDescriptors = n;
    }

    public int getMaxNumDescriptors() {
        return this.iMaxNumberDescriptors;
    }

    public abstract String getDataBlockName();

    public abstract String uploadDataBlockData(String var1);

    public abstract String extractDataBlockData();

    public abstract void removeDescriptor(int var1);

    public abstract void removeAllDescriptors();

    public abstract boolean addDescriptor(CEADescriptor var1);

    public abstract boolean isJustOneCopyAllowed();

    public abstract int getDataBlockChecksum();
}

